// Header File
// Created 23/10/2003; 22:31:16

//Sprites billes
#define Start_BillesGFX								0
#define BillesGFX_size								15

void *SPRITE_BILLE=NULL;

//Sprites Square
#define Start_SquareGFX								16
#define Square_corner_left_size				16
#define Square_corner_right_size			16
#define	Square_left_and_right_size		64
#define Square_up_size								16
#define Square_doors0_size						64

void *SPRITE_SQUARE_corner_left=NULL;
void *SPRITE_SQUARE_corner_right=NULL;
void *SPRITE_SQUARE_left_and_right=NULL;
void *SPRITE_SQUARE_up=NULL;
void *SPRITE_SQUARE_doors0=NULL;

//Sprites dcors
#define Start_DecorsGFX								192
#define DecorsGFX_size								256

#define GetSprite_decors(x)						(void*)(FileGFX+Start_DecorsGFX+DecorsGFX_size*x)
void *SPRITE_DECORS[6];

//Sprites blocks
#define Start_BlocksGFX								1728
#define BlocksGFX_size								24

#define GetSprite_blocks(x)						(void *)(FileGFX+Start_BlocksGFX+BlocksGFX_size*(x-1))
void *SPRITE_BLOCKS[14];

//Sprites Font0
#define Start_Font0GFX								1992
#define Font0GFX_size									8

#define GetSprite_Font0(x)						(void *)(FileGFX+Start_Font0GFX+Font0GFX_size*x)
void *SPRITE_FONT0[40];

//Sprites Rackets - Game
#define Start_RacketsGFX							2312
#define Start_RacketsGFX_ANIMS				4152
#define Start_RacketsGFX_DIVERS				7336
#define Rackets_size0									108					//32x9
#define Rackets_size1									136					//40x9
#define Rackets_size2									156					//32x13

//anim, racket n
void *SPRITE_RACKETS[11][6];					

//Sprites Bonus
#define Start_BonusGFX								7552
#define Bonus_size										28
#define Bonus_mask_size								14
void *SPRITE_BONUS [13][8];
void *SPRITE_BONUS_mask [2];

//Sprite life
#define Start_LifeGFX									10492
#define Life_size											36
void *SPRITE_LIFE=NULL;
#define Create_SpriteLife()						SPRITE_LIFE=(void *)(FileGFX+Start_LifeGFX);

//Sprite missile
#define Start_MissilesGFX							10528
#define Missile_size0									42
#define Missile_size1									18
void *SPRITE_MISSILE[3];

//Sprite Fleche
#define Start_FlechesGFX							10606
#define Fleche_size										8
void *SPRITE_FLECHE[4];

//Sprite Logos
#define Start_LogosGFX								10638
#define Logo_size											576
void *SPRITE_LOGO[6];

//Sprite Doors EndLevel
#define Start_EndDoorsGFX							14094
#define EndDoors_size									36
void *SPRITE_ENDDOORS[3];

//Sprite Intro Title
#define Start_IntroTitle0							14202
#define Start_IntroTitle1							21882
void *IMG_IntroTitle0=NULL;
void *IMG_IntroTitle1=NULL;

//Sprite Intro0
#define Start_Introduction0_Picture0	25882
#define Start_Introduction0_Picture1	30662
void *IMG_Introduction0_Picture0=NULL;
void *IMG_Introduction0_Picture1=NULL;

//Sprite Intro1 DOH Vaisseau
#define Start_Introduction1_DOHSHIP		33342
#define Create_PictureIntro1_DOHSHIP()	IMG_Introduction1=(void *)(FileGFX+Start_Introduction1_DOHSHIP);
void *IMG_Introduction1=NULL;			

//Sprite Intro1 Animation Vaisseau
#define Start_Introduction1_SHIP			38022
void *SPRITE_INTRO1_SHIP [15];

//Sprite Intro1 Animation Explosion
#define Start_Introduction1_EXPLOSE		40014
#define Intro1_Explose_size						156
void *SPRITE_INTRO1_EXPLOSE [10];

//Sprites Monstres
#define Start_Monsters								41574
#define Start_MonstersDead						42342
#define Monsters_size									96
#define START_MonstersSprites					0
#define START_MonstersDeadSprites			13		
void *SPRITE_MONSTER [19][8];

//Cration de la table de sprites des billes
void Create_SpritesBilles (void) {SPRITE_BILLE=(void*)(FileGFX+Start_BillesGFX);}

//Cration de la table de sprites square
void Create_SpritesSquare (void)
{
	SPRITE_SQUARE_corner_left=(void *)(FileGFX+Start_SquareGFX);
	SPRITE_SQUARE_corner_right=(void *)(FileGFX+Start_SquareGFX+Square_corner_left_size);
	SPRITE_SQUARE_left_and_right=(void *)(FileGFX+Start_SquareGFX+Square_corner_left_size+Square_corner_right_size);
	SPRITE_SQUARE_up=(void *)(FileGFX+Start_SquareGFX+Square_corner_left_size+Square_corner_right_size+Square_left_and_right_size);
	SPRITE_SQUARE_doors0=(void *)(FileGFX+Start_SquareGFX+Square_corner_left_size+Square_corner_right_size+Square_left_and_right_size+Square_up_size);
}

//Cration de la table de sprites dcors
void Create_SpritesDecors (void)
{
	for (int i=0;i<6;i++)
		SPRITE_DECORS[i]=GetSprite_decors (i);
}

//Cration de la table de sprites des blocks
void Create_SpritesBlocks (void)
{
	for (int i=1;i<12;i++)
		SPRITE_BLOCKS[i]=GetSprite_blocks (i);
	
	SPRITE_BLOCKS[12]=GetSprite_blocks (6);							//Brique acier SPEC0
	SPRITE_BLOCKS[13]=GetSprite_blocks (11);						//Brique divis en 2 SPEC2
}


//Cration de la table de sprites FONT0
void Create_SpritesFont0 (void)
{
	for (int i=0;i<40;i++)
		SPRITE_FONT0[i]=GetSprite_Font0 (i);
}


//Crations de la table de sprites RACKETS
void Create_SpriteRackets (void)
{
	//--GAME--
	//Sprites 00  01
	for (int j=0;j<2;j++)
		for (int i=0;i<4;i++)
			SPRITE_RACKETS[j][i]=(void *)(FileGFX+Start_RacketsGFX+(j*(4*Rackets_size0))+(i*Rackets_size0));
	
	//Sprite 02
	for (int i=0;i<4;i++)
		SPRITE_RACKETS[2][i]=(void *)(FileGFX+Start_RacketsGFX+(8*Rackets_size0)+(i*Rackets_size1));
	
	//Sprite 03	
	for (int i=0;i<4;i++)
		SPRITE_RACKETS[3][i]=(void *)(FileGFX+Start_RacketsGFX+(8*Rackets_size0)+(4*Rackets_size1)+(i*Rackets_size0));
		
	//--ANIMATIONS--
	//Sprite 04
	for (int i=0;i<4;i++)
		SPRITE_RACKETS[4][i]=(void *)(FileGFX+Start_RacketsGFX_ANIMS+(i*Rackets_size0));
		
	//Sprite 05
	for (int i=0;i<4;i++)
		SPRITE_RACKETS[5][i]=(void *)(FileGFX+Start_RacketsGFX_ANIMS+(4*Rackets_size0)+(i*Rackets_size1));
		
	//Sprite 06
	for (int i=0;i<6;i++)
		SPRITE_RACKETS[6][i]=(void *)(FileGFX+Start_RacketsGFX_ANIMS+(4*Rackets_size0)+(4*Rackets_size1)+(i*Rackets_size0));
	
	//Sprite 07
	for (int i=0;i<5;i++)
		SPRITE_RACKETS[7][i]=(void *)(FileGFX+Start_RacketsGFX_ANIMS+(4*Rackets_size0)+(4*Rackets_size1)+(6*Rackets_size0)+(i*Rackets_size2));
	
	//Sprite 08
	for (int i=0;i<5;i++)
		SPRITE_RACKETS[8][i]=(void *)(FileGFX+Start_RacketsGFX_ANIMS+(4*Rackets_size0)+(4*Rackets_size1)+(6*Rackets_size0)+(5*Rackets_size2)+(i*Rackets_size2));

	
	//--DIVERS (BONUS)--
	//Sprite 08
	SPRITE_RACKETS[9][0]=(void *)(FileGFX+Start_RacketsGFX_DIVERS);
	SPRITE_RACKETS[10][0]=(void *)(FileGFX+Start_RacketsGFX_DIVERS+Rackets_size0);
}

//Crations de la table de sprites BONUS
void Create_SpriteBonus (void)
{
	//Bonus n
	for (int i=0;i<13;i++)
	{
		//Animation n
		for (int j=0;j<8;j++)
			SPRITE_BONUS [i][j]=(void *)(FileGFX+Start_BonusGFX+((8*Bonus_size)*i)+(j*Bonus_size));
	}
	
	//Masques
	for (int i=0;i<2;i++)
		SPRITE_BONUS_mask [i]=(void *)(FileGFX+Start_BonusGFX+((8*Bonus_size)*13)+(i*Bonus_mask_size));
}

//Crations de la table de sprites MISSILES
void Create_SpriteMissiles (void)
{
	SPRITE_MISSILE [0]=(void *)(FileGFX+Start_MissilesGFX);
	SPRITE_MISSILE [1]=(void *)(FileGFX+Start_MissilesGFX+Missile_size0);
	SPRITE_MISSILE [2]=(void *)(FileGFX+Start_MissilesGFX+Missile_size0+Missile_size1);
}

//Cration de la table de sprites FLECHES
void Create_SpriteFleches (void)
{
	//Fleche n
	for (int i=0;i<4;i++)
		SPRITE_FLECHE [i]=(void *)(FileGFX+Start_FlechesGFX+(i*Fleche_size));
}

//Crations de la table de sprites LOGOS
void Create_SpriteLogos (void)
{
	//Logo n
	for (int i=0;i<6;i++)
		SPRITE_LOGO [i]=(void *)(FileGFX+Start_LogosGFX+(i*Logo_size));
}

//Cration de la table de sprites ENDDOORS
void Create_SpriteEndDoors (void)
{
	//EndDoors n
	for (int i=0;i<3;i++)
		SPRITE_ENDDOORS [i]=(void *)(FileGFX+Start_EndDoorsGFX+(i*EndDoors_size));
}

//Crations des pointeurs d'images IntroTitle
void Create_ImageIntroTitle (void)
{
	//TI92+/V200
	IMG_IntroTitle0=(void *)(FileGFX+Start_IntroTitle0);
	//TI89
	IMG_IntroTitle1=(void *)(FileGFX+Start_IntroTitle1);
}

//Crations des pointeurs d'images Introduction0
void Create_ImageIntroduction0 (void)
{
	//TI92+/V200
	IMG_Introduction0_Picture0=(void *)(FileGFX+Start_Introduction0_Picture0);
	//TI89
	IMG_Introduction0_Picture1=(void *)(FileGFX+Start_Introduction0_Picture1);
}

//Crations de la table de sprites INTRO1 SHIP
void Create_SpriteIntro1Ship (void)
{
	//Table de sprites
	SPRITE_INTRO1_SHIP [0]=(void *)(FileGFX+Start_Introduction1_SHIP);
	SPRITE_INTRO1_SHIP [1]=SPRITE_INTRO1_SHIP [0]+(((56/8)*2)*18);
	SPRITE_INTRO1_SHIP [2]=SPRITE_INTRO1_SHIP [1]+(((56/8)*2)*18);
	SPRITE_INTRO1_SHIP [3]=SPRITE_INTRO1_SHIP [2]+(((40/8)*2)*18);
	SPRITE_INTRO1_SHIP [4]=SPRITE_INTRO1_SHIP [3]+(((32/8)*2)*18);
	SPRITE_INTRO1_SHIP [5]=SPRITE_INTRO1_SHIP [4]+(((32/8)*2)*18);
	SPRITE_INTRO1_SHIP [6]=SPRITE_INTRO1_SHIP [5]+(((32/8)*2)*18);
	SPRITE_INTRO1_SHIP [7]=SPRITE_INTRO1_SHIP [6]+(((32/8)*2)*18);
	SPRITE_INTRO1_SHIP [8]=SPRITE_INTRO1_SHIP [7]+(((32/8)*2)*18);
	SPRITE_INTRO1_SHIP [9]=SPRITE_INTRO1_SHIP [8]+(((16/8)*2)*18);
	SPRITE_INTRO1_SHIP [10]=SPRITE_INTRO1_SHIP [9]+(((16/8)*2)*18);
	SPRITE_INTRO1_SHIP [11]=SPRITE_INTRO1_SHIP [10]+(((32/8)*2)*18);
	SPRITE_INTRO1_SHIP [12]=SPRITE_INTRO1_SHIP [11]+(((32/8)*2)*18);
	
	//Missile
	SPRITE_INTRO1_SHIP [13]=SPRITE_INTRO1_SHIP [12]+(((16/8)*2)*18);
	
	//Capsule
	SPRITE_INTRO1_SHIP [14]=SPRITE_INTRO1_SHIP [13]+((2*3)*8);
}

//Cration de la table de sprites INTRO1 EXPLOSE
void Create_SpriteIntro1_Explose (void)
{
	//Parcours sprites
	for (int i=0;i<10;i++)
		SPRITE_INTRO1_EXPLOSE [i]=(void *)(FileGFX+Start_Introduction1_EXPLOSE+(i*Intro1_Explose_size));
}

//Crations de la table de sprites MONSTERS
void CreateSpriteMonsters (void)
{
	int i=0;
	
	//Monstres
	//00
	for (int j=0;j<8;j++,i++)
		SPRITE_MONSTER [START_MonstersSprites][j]=(void *)(FileGFX+Start_Monsters+((i*Monsters_size)));
	
	//Monstres Dead
	//00
	i=0;
	for (int j=0;j<6;j++,i++)
		SPRITE_MONSTER [START_MonstersDeadSprites][j]=(void *)(FileGFX+Start_MonstersDead+((i*Monsters_size)));
}

//***********************************
//Crations des pointeurs de sprites.
//***********************************
void Create_Sprites (void)
{
	//Billes
	Create_SpritesBilles ();
	
	//Square (barres dcors)
	Create_SpritesSquare ();
	
	//Dcors (motifs rpt)
	Create_SpritesDecors ();
	
	//Blocks
	Create_SpritesBlocks ();
	
	//Font0
	Create_SpritesFont0 ();
	
	//Rackets
	Create_SpriteRackets ();
	
	//Bonus
	Create_SpriteBonus ();
	
	//Vies
	Create_SpriteLife ();
	
	//Missiles
	Create_SpriteMissiles ();
	
	//Fleches
	Create_SpriteFleches ();
	
	//Logos
	Create_SpriteLogos ();
	
	//EndDoors
	Create_SpriteEndDoors ();
	
	//Introduction Title
	Create_ImageIntroTitle ();
	
	//Introduction0
	Create_ImageIntroduction0 ();
	
	//Introduction1
	Create_PictureIntro1_DOHSHIP ();
	
	//Introduction1 Ship
	Create_SpriteIntro1Ship ();
	
	//Introduction1 Explosions
	Create_SpriteIntro1_Explose ();
	
	//Monstres
	CreateSpriteMonsters ();
}
